<?php
class Database {
    private $_db_conn;
    private $_db_host;
    private $_db_socket;
    private $_db_database;
    private $_db_username;
    private $_db_password;
    private $_db_table_prefix;


    /**
     * @param $db_config
     * @throws Exception
     */
    public function __Construct($db_config)
    {
        $arr = explode(':', $db_config['hostname']);
        $host = $arr[0];
        $socket = $arr[1];
        $this->_db_host = $host;
        $this->_db_socket = $socket;
        $this->_db_database = $db_config['database'];
        $this->_db_username = $db_config['username'];
        $this->_db_password = $db_config['password'];
        $this->_db_table_prefix = $db_config['table_prefix'];
        $this->_DbConnect();

        if ($db_config["utf8"]) {
            $this->Query('SET NAMES utf8');
            $this->Query('SET CHARACTER SET utf8');
        }
    }


    private function _DbConnect()
    {
        $this->_db_conn = @mysqli_connect($this->_db_host, $this->_db_username, $this->_db_password, $this->_db_database, null, $this->_db_socket);
        if (mysqli_connect_errno()) {
            throw new Exception('Database configuration error: '.mysqli_connect_error());
        }
    }


    /**
     * @param string $str
     * @return string
     */
    public function FixUserQuery($str)
    {
        $str = stripslashes(trim($str));
        $str = mysqli_real_escape_string($this->_db_conn, $str);
        return $str;
    }


    /**
     * @param $q
     * @return bool|mysqli_result
     * @throws Exception
     */
    public function Query($q)
    {
        $q = str_replace('#__', $this->_db_table_prefix, $q);
        if ($r = mysqli_query($this->_db_conn, $q)) {
            return $r;
        }

        if (mysqli_errno($this->_db_conn) == 2006) {
            $this->_DbConnect();
            WriteToLog('Reconnecting with MySQL');
            if ($r = mysqli_query($this->_db_conn, $q)) {
                return $r;
            }
        }

        if (mysqli_errno($this->_db_conn)) {
            WriteToLog('SQL Error:'.mysqli_error($this->_db_conn).' ['.mysqli_errno($this->_db_conn).']');
            WriteToLog('SQL Query:'.$q);

            // @todo we need to either throw an exception or log the error for the calling script to log in the ow ecommerce logs
            //throw new Exception("MySQL query failed: ".mysqli_error($this->_db_conn).' ['.mysqli_errno($this->_db_conn).']');
            //$ecom = new Handler();
            //$ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, "MySQL query failed: ".mysqli_error($this->_db_conn).' ['.mysqli_errno($this->_db_conn).']');
            //$ecom->ReturnResponseXML();
        }
        return false;
    }


    /**
     * @param $result_ptr
     * @return int
     */
    public function NumRows($result_ptr)
    {
        return mysqli_num_rows($result_ptr);
    }


    /**
     * @param $result_ptr
     * @return null|object
     */
    public function FetchObject($result_ptr)
    {
        return mysqli_fetch_object($result_ptr);
    }


    /**
     * @param $result_ptr
     * @param int $row
     * @return mixed
     */
    public function Result($result_ptr, $row = 0)
    {
        if ($row < mysqli_num_rows($result_ptr)) {
            if (mysqli_data_seek($result_ptr, $row)) {
                $row = mysqli_fetch_row($result_ptr);
                return $row[0];
            }
        }
    }


    /**
     * @param $result_ptr
     * @return array|null
     */
    public function FetchAssoc($result_ptr)
    {
        return mysqli_fetch_assoc($result_ptr);
    }


    /**
     * @param $result_ptr
     * @return array|null
     */
    public function FetchArray($result_ptr)
    {
        return mysqli_fetch_array($result_ptr);
    }


    /**
     * @return int
     */
    public function AffectedRows()
    {
        return mysqli_affected_rows($this->_db_conn);
    }


    /**
     * @return int|string
     */
    public function InsertId()
    {
        return mysqli_insert_id($this->_db_conn);
    }


    /**
     * @param $result_ptr
     * @return int
     */
    public function NumFields($result_ptr)
    {
        return mysqli_num_fields($result_ptr);
    }


    /**
     * @param $result_ptr
     * @return bool|object
     */
    public function FetchField($result_ptr)
    {
        return mysqli_fetch_field($result_ptr);
    }

     /**
     * @param $result_ptr
     * @return array|null
     */
    public function ResultToArray($result_ptr) {

        $result = array();

        // Not always available so check if installed
        $mysqlnd_available = function_exists('mysqli_fetch_all');

        if ($mysqlnd_available)
        {
            $result = mysqli_fetch_all($result_ptr);
        }
        else
        {
            while ($row = mysqli_fetch_row($result_ptr) ) {
                $result[] = $row;
            }
        }

        return $result ?: array();
    }
}
