<?php
/**
 * Update stock levels
 *
 * System/Version:      Shopify
 * Developer:           Toby Loudon
 * OnTime Ref:          50102
 * Completed:           28/07/2020
 * Production URL:      http://cestevenson-orderwise.net/orderwise_shopify/stock.php
 * Staging URL:
 */

set_time_limit(300);
require 'config.php';


// Instantiate Shopify validate the store id from the url
// Get the Shopify stock location ID to use
try {
    $shopify = new Shopify($ecom->GetStoreId());

    // 19/05/2020 | CB | 49588 | Added lookups to match OW stock location to Shopify
    $stock_location_lookup = new CsvLookupLoader('stock_locations.csv');
} catch (Exception $e) {
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, $e->getMessage());
    $ecom->ReturnResponseXML();
}


// Handle the POST data
$export_data = stripslashes(trim($_POST['ExportData']));
if ($export_data == "") {
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_WARNING, 'No export data to process');
    $ecom->ReturnResponseXML();
}
$ecom->ArchiveOrderwiseExportedData('stock', $export_data);
if (!$xml = @simplexml_load_string($export_data)) {
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, 'Exported XML invalid');
    $ecom->ReturnResponseXML();
}
if (count($xml) == 0) {
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_WARNING, 'No data exported');
    $ecom->ReturnResponseXML();
}


/*
* Get the current inventory
 *
 * NOTE - we no longer use the inventory amount that is given back as cannot trust
 * this is correct. Shopify have deprecated the fields we used to use and instead
 * have a new inventory level call we would have to make to get stock levels for a
 * specific location
 * https://help.shopify.com/en/api/reference/inventory/inventorylevel#index
 * To save on API calls, we do not call this and instead just use the stock level
 * that is given from OrderWise to perform the update
 * We still need the below call however to get the variant id to use to update stock
*/
$current_inventory = $shopify->LoadCurrentStockLevels();
if (count($current_inventory) == 0) {
    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, 'No inventory found in Shopify');
    $ecom->ReturnResponseXML();
}

WriteToLog('Current inventory: ' . count($current_inventory));

$sku_filter_list = $ecom->GetSkuFilterList();
$updated = 0;
foreach ($xml as $x) {
    $sku = strtoupper(trim($x->sku));
    $new_stock = (float)$x->free_stock;
    if ($new_stock < 0) {
        $new_stock = 0;
    }

    if (empty($sku)) {
        continue;
    }

    // Check we're filtering the skus for testing
    if ($ecom->GetSkuFilterCount() > 0 && !isset($sku_filter_list[$sku])) {
        continue;
    }

    if (!isset($current_inventory[$sku])) {
        $ecom->AppendResponseMessage(XML_REPONSE_TYPE_WARNING, 'No match found for ' . $sku);
        continue;
    }

    foreach ($current_inventory[$sku] as $k => $v) {

        //22/05/2019 | TL | Dev 43368 | Script Edit to handle multiple stock locations | Get Stock Location ID
        try {
            // 24/07/2019 | DS | Dev 44392 | Script edit to support fetching the first stock location ID in the event the old export definition is used with the new scripts and a store without multiple stock locations
            if ($shopify->IsMultipleStockLocation()) {
                if (!empty($x->stock_location)) {
                    // 19/05/2020 | CB | 49588 | Added lookups to match OW stock location to Shopify
                    $stock_location_name = $stock_location_lookup->getKeyFromLookupValueIfExists(trim($x->stock_location));
                    $shopify_stock_location_id = $shopify->GetLocationIDFromName($stock_location_name);
                } elseif (!empty($_GET['stock-location'])) {
                    $shopify_stock_location_id = $shopify->GetLocationIDFromName(trim($_GET['stock-location']));
                } else {
                    $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR,
                        'Stock location name not set correctly in the XML, please check your export definition is correct');
                }
            } else {
                $shopify_stock_location_id = $shopify->GetFirstStockLocation();
            }
        } catch (Exception $e) {
            $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, $e->getMessage());
            continue;
        };


        // Update the product if quantities do not match
        $inventory_update = array(
            'inventory_item_id' => $v['inventory_item_id'],
            'location_id' => $shopify_stock_location_id,
            'available' => $new_stock,
        );

        try {
            $shopify->UpdateStockLevelForSpecificLocation($sku, $inventory_update);
            $updated++;
        } catch (Exception $e) {
            $ecom->AppendResponseMessage(XML_REPONSE_TYPE_ERROR, $e->getMessage());
        }
    }
}


// Send any response messages back
$ecom->AppendResponseMessage(XML_REPONSE_TYPE_LOG,
    'Updated ' . $updated . ' record(s) from ' . count($xml) . ' exported.');
$ecom->ReturnResponseXML();